
// Mp2DecoderDlg.h : header file
//

#pragma once
#include "afxwin.h"

#include "MyProgressCtrl.h"

// CMp2DecoderDlg dialog
class CMp2DecoderDlg : public CDialogEx
{
// Construction
public:
	CMp2DecoderDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CMp2DecoderDlg)
	enum { IDD = IDD_MP2DECODER_DIALOG };
	MyProgressCtrl			m_progTimeBar;
	CButton						m_btnStart;
	CButton						m_btnStop;
	CButton						m_btnBrowser;
	CEdit							m_editSrcFilePath;
	CEdit							m_editDestFilePath;
	//}}AFX_DATA

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnPaint();
	afx_msg void OnBnClickedBtnStart();
	afx_msg void OnBnClickedBtnStop();
	afx_msg void OnBnClickedBtnBrowser();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:

	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	CString				GetWorkingPath( );

	BOOL				IsFileExists( const TCHAR* pFile );

	CStringVector SplitString( const CString& strSource, const CString& delim, bool bRemoveNone );

public:	

	DEVICE_HANDLE				m_hAudioSwDecoderDev;						// MP2 DECODER DEVICE	

	CRITICAL_SECTION			m_hAccessFileCriticalSection;					// FILE ACCESS CRITICAL SECTION

	BOOL									m_bDecodeBuffer;	

	HANDLE								m_hMp2DecodeThread;

	ULONG								m_hMp2DecodeThreadNumber;

	BYTE *								m_pMp2FrameBuffer;

	ULONG								m_nMp2FrameBufferLen;

	BYTE *								m_pPCMFrameBuffer;

	ULONG								m_nPCMFrameBufferLen;
	
	CString									m_strSrcFilePath;

	CString									m_strDestFilePath;

	CStdioFile *							m_pTxtFile;

	CFile *									m_pBinFile;	

	WAVFILE 							m_pWavFile;

	ULONG								m_nCurDecodeSample;

	ULONG								m_nTotalAudioSamples;
};
